<%--
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "16kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.payroll.system.vo.DetailCardVo"
%><%
DetailCardVo vo = (DetailCardVo)request.getAttribute(MospConst.ATT_VO);
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="DetailCard">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Card">
		<table>
			<tr>
				<td class="TitleTd"><%= HtmlUtility.getRequiredMark() %><%= vo.NAM_TYPE + vo.getName("C_SEPARATOR") %></td>
				<td class="InputTd">
					<select id="<%= DetailCardVo.PRM_PLT_TYPE %>" name="<%= DetailCardVo.PRM_PLT_TYPE %>">
						<%= HtmlUtility.getSelectOption(vo.getPitType(), vo.getPltType()) %>
					</select>
					<input type="hidden" id="<%= DetailCardVo.PRM_HID_TYPE %>" name="<%= DetailCardVo.PRM_HID_TYPE %>" value="" />
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= HtmlUtility.getRequiredMark() %><%= vo.NAM_CODE + vo.getName("C_SEPARATOR") %></td>
				<td class="InputTd">
					<div id="lblPrefix"></div>
					<input type="text" class="CodeTextBox" id="<%= DetailCardVo.PRM_TXT_CODE %>" name="<%= DetailCardVo.PRM_TXT_CODE %>" value="<%= vo.getEscTxtCode() %>" />
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= HtmlUtility.getRequiredMark() %><%= vo.NAM_NAME + vo.getName("C_SEPARATOR") %></td>
				<td class="InputTd">
					<input type="text" class="TextBox" id="<%= DetailCardVo.PRM_TXT_NAME %>" name="<%= DetailCardVo.PRM_TXT_NAME %>" value="<%= vo.getEscTxtName() %>" />
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= HtmlUtility.getRequiredMark() %><%= vo.NAM_ABBR + vo.getName("C_SEPARATOR") %></td>
				<td class="InputTd">
					<input type="text" class="TextBox" id="<%= DetailCardVo.PRM_TXT_ABBR %>" name="<%= DetailCardVo.PRM_TXT_ABBR %>" value="<%= vo.getEscTxtAbbr() %>" />
				</td>
			</tr>
			<tr>
				<td class="TitleTd"><%= HtmlUtility.getRequiredMark() %><%= vo.NAM_DELETE + vo.getName("C_SEPARATOR") %></td>
				<td class="InputTd">
					<select id="<%= DetailCardVo.PRM_PLT_DELETE %>" name="<%= DetailCardVo.PRM_PLT_DELETE %>">
						<%= HtmlUtility.getDeleteFlagSelectOption(vo.getPltDelete()) %>
					</select>
					<input type="hidden" id="<%= DetailCardVo.PRM_HID_DELETE %>" name="<%= DetailCardVo.PRM_HID_DELETE %>" value="" />
				</td>
			</tr>
		</table>
	</div>
</div>
<div class="Footer">
	<button type="button" class="ExecuteButton" onclick="submitForm(document.form, 'P7017')"><%= vo.getName("C_REGIST") %></button>
	<button type="button" class="ExecuteButton" onclick="doSubmit(document.form, 'P7012')"><%= vo.getName("C_LIST") + vo.getName("C_TO") %></button>
</div>
<%= HtmlUtility.getFooter(vo) %>
